<?php
if (!defined('&quot;'))
	define('&quot;', '"');
if (!defined('_BR_'))
   define('_BR_',chr(13).chr(10));

class TIniFileEx {
    public $filename;
    public $arr;
    function __construct($file = false){
        if ($file)
            $this->loadFromFile($file);
    }
    function initArray(){
        $this->arr = parse_ini_file($this->filename, true);
    }

    function loadFromFile($file){
        $result = true;
        $this->filename = $file;
        if (file_exists($file) && is_readable($file)){
            $this->initArray();
        }
        else
            $result = false;
        return $result;
    }

    function read($section, $key, $def = '', $decode = 0){
        if (isset($this->arr[$section][$key])){
            return ( ($decode == 1) ? str_replace('\&quot;', '"', urldecode( $this->arr[$section][$key] )) : $this->arr[$section][$key] );
        } else
            return $def;
    }
    function write($section, $key, $value, $encode = 0){
        if (is_bool($value)) {
            $value = $value ? 1 : 0;
        } else {
        	$value = str_replace('"', '&quot;', $value);
        }
        $this->arr[$section][$key] = ( ($encode == 1) ?  htmlentities(urldecode($value), ENT_QUOTES) : $value);
        $this->updateFile();
    }

    function eraseSection($section){
        if (isset($this->arr[$section]))
            unset($this->arr[$section]);
        $this->updateFile();
    }

    function deleteKey($section, $key){
        if (isset($this->arr[$section][$key]))
            unset($this->arr[$section][$key]);
        $this->updateFile();
    }

    function readSections(&$array){
        $array = array_keys($this->arr);
        return $array;
    }

    function readKeys($section, &$array){
        if (isset($this->arr[$section])){
            $array = array_keys($this->arr[$section]);
            return $array;
        }
        return array();
    }

    function updateFile(){
        $result = '';
        foreach ($this->arr as $sname=>$section){
            $result .= '[' . $sname . ']' . _BR_;
            foreach ($section as $key=>$value){
                $result .= $key .'="'.$value.'"'. _BR_;
            }
            $result .= _BR_;
        }
        file_put_contents($this->filename, $result);
        return true;
    }

    function __destruct(){
//        $this->updateFile();
    }
}
?>