<?php
if(!(is_readable(realpath(dirname(__FILE__)).'/mysqlroutines.inc'))) {
        die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/mysqlroutines.inc');
} else {
        include_once(realpath(dirname(__FILE__)).'/mysqlroutines.inc');
}

function db_insertMailInQueue($cn, $idmaitype, $mq_recipients, $mq_replyto, $mq_subject, $mq_body, $priority = 10)
{
        $query  = "INSERT IGNORE INTO `mailqueue` (`idmaitype`, `mq_recipients`, `mq_replyto`, `mq_subject`, `mq_body`) 
                        VALUES ('".mysqli_real_escape_string($cn,$idmaitype)."', 
                                '".mysqli_real_escape_string($cn,$mq_recipients)."', 
                                '".mysqli_real_escape_string($cn,$mq_replyto)."', 
                                '".mysqli_real_escape_string($cn,$mq_subject)."', 
                                '".mysqli_real_escape_string($cn,$mq_body)."');";
        return db_runQuery($cn, $query, 'db_insertMailInQueue');
}

function db_getMailQueue($cn, $idmaitype = NULL, $limit = 1000)
{
        $query  = "SELECT * FROM `mailqueue` ".(($idmaitype && $idmaitype !== NULL) ? " 
                           WHERE idmaitype = ".mysqli_real_escape_string($cn,$idmaitype) : "")." 
                           ORDER BY `priority` ASC 
                           LIMIT ".(($limit && $limit !== NULL) ? mysqli_real_escape_string($cn,$limit) : "1000").";";
        return db_runQueryAndReturnArray($cn, $query, 'db_getMailQueue');
}

function db_getMailQueueType($cn, $type)
{
        if ($type === NULL) {
                return $type;
        } else {
                $query  = "SELECT `idmaitype` FROM `maitypes` WHERE `mt_name` like '".mysqli_real_escape_string($cn,$type)."'";
                $arr = db_runQueryAndReturnArray($cn, $query, 'db_getMailQueueType');
                if (sizeof($arr) > 0){
                        return $arr[0]['idmaitype'];
                } else {
                        return NULL;
                }
        }
}

function db_deleteMailFromQueue($cn, $idmailqueue)
{
        $query  = "DELETE FROM `mailqueue` WHERE idmailqueue = ".mysqli_real_escape_string($cn,$idmailqueue).";";
        return db_runQuery($cn, $query, 'db_deleteMailFromQueue');
}

function db_getUpdateMailQueuePriority($cn, $idmailqueue, $priorityStep = 10)
{
        $query  = "UPDATE `mailqueue` SET `priority` =  `priority` + ".mysqli_real_escape_string($cn,$priorityStep)."  WHERE idmailqueue = ".mysqli_real_escape_string($cn,$idmailqueue).";";
        return db_runQuery($cn, $query, 'db_getUpdateMailQueuePriority');
}

function db_createMailQueue_NewPoll($cn, $idpolltype, $idbranch, $idproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT pt.skpolltype, IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent, lng.lang_short, CASE WHEN IFNULL(po.skproject,0) > 0 THEN 0 ELSE po.skbranch END as skbranch, IFNULL(po.skproject,0) as skproject, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name 
                FROM users u
                        INNER JOIN useranswers ua ON u.iduser = ua.iduser
                        INNER JOIN polltypes pt ON pt.skpolltype = ua.skpolltype
                        INNER JOIN pollingobjects po ON po.skpollingobject = ua.skpollingobject
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                WHERE  u.user_isactive = 1 AND ua.hasanswer = 0 AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."' 
                AND ".(isset($idproject) ? " po.skproject in (SELECT skproject FROM projects WHERE idproject = '".mysqli_real_escape_string($cn, $idproject)."') " : " po.skbranch in (SELECT skbranch FROM branches WHERE idbranch = '".mysqli_real_escape_string($cn, $idbranch)."') " ).";        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_NewPoll');
        foreach ($ar as $mail) {
                // 62378
                $finishdate = "";
                if ($mail[ "skbranch" ] == 0 ) {
                        $finishdate = db_getPollFinishDateBySkroject($cn, $mail[ "skpolltype"], $mail[ "skproject" ]);
                } else {
                        $finishdate = db_getPollFinishDateBySkBranch($cn, $mail[ "skpolltype"], $mail[ "skbranch" ]);
                }
                $url = getCurPageURLWO(array("secureservice", "service")).'poll.php?&idpolltype='.$idpolltype."&".($mail["skproject"] != 0 ? 'skproject='.$mail["skproject"] : 'skbranch='.$mail["skbranch"]);
                $userlang = $mail['lang_short'];
                createMailNewPoll($mail['user_email'], getResourceByLang('email.newpoll.subject', $userlang), buildFullPollName($cn, $mail), $url, $userlang, $mail['user_name'], $finishdate);
        }
        return $ar;       
}

function db_createMailQueue_DeletePoll($cn, $idpolltype, $skbranch, $skproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  lng.lang_short, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name, IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent
                FROM users u
                        INNER JOIN useranswers ua ON u.iduser = ua.iduser
                        INNER JOIN polltypes pt ON pt.skpolltype = ua.skpolltype
                        INNER JOIN pollingobjects po ON po.skpollingobject = ua.skpollingobject
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent)
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        WHERE  u.user_isactive = 1 ".
                        ($skproject === NULL ? " AND po.skbranch = ".mysqli_real_escape_string($cn, $skbranch) : " AND po.skproject = ".mysqli_real_escape_string($cn, $skproject)).
                        " AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."';        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_DeletePoll');
        foreach ($ar as $mail) {
                $userlang = $mail['lang_short'];
                $subject = $mail['polltype_name'].': '.($skproject === NULL ? db_getBranchName($cn, $skbranch, $mail["user_idlanguagecontent"]) : db_getProjectName($cn, $skproject, $mail["user_idlanguagecontent"])).'';
                createMailDeletePoll($mail['user_email'], getResourceByLang('email.deletepoll.subject', $userlang), $subject, '', $userlang, $mail['user_name']);
        }
        return $ar;       
}

function db_createMailQueue_HidePoll($cn, $idpolltype, $skbranch, $skproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  lng.lang_short, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name, IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent
                FROM users u
                        INNER JOIN useranswers ua ON u.iduser = ua.iduser
                        INNER JOIN polltypes pt ON pt.skpolltype = ua.skpolltype
                        INNER JOIN pollingobjects po ON po.skpollingobject = ua.skpollingobject
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent)
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        WHERE  u.user_isactive = 1 ".
                        ($skproject === NULL ? " AND po.skbranch = ".mysqli_real_escape_string($cn, $skbranch) : " AND po.skproject = ".mysqli_real_escape_string($cn, $skproject)).
                        " AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."';        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_HidePoll');
        foreach ($ar as $mail) {
                $userlang = $mail['lang_short'];
                $subject = $mail['polltype_name'].' : '.($skproject === NULL ? db_getBranchName($cn, $skbranch, $mail["user_idlanguagecontent"]) : db_getProjectName($cn, $skproject, $mail["user_idlanguagecontent"])).'';
                createMailHidePoll($mail['user_email'], getResourceByLang('email.hidenpoll.subject', $userlang), $subject, '', $userlang, $mail['user_name']);
        }
        return $ar;       
}

function db_createMailQueue_ContinuePoll($cn, $idpolltype, $skbranch, $skproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  pt.skpolltype, lng.lang_short, CASE WHEN IFNULL(po.skproject,0) > 0 THEN 0 ELSE po.skbranch END as skbranch, IFNULL(po.skproject,0) as skproject, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name, IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent
                FROM users u
                        INNER JOIN useranswers ua ON u.iduser = ua.iduser
                        INNER JOIN polltypes pt ON pt.skpolltype = ua.skpolltype
                        INNER JOIN pollingobjects po ON po.skpollingobject = ua.skpollingobject
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent)
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        WHERE  u.user_isactive = 1 ".
                        ($skproject === NULL ? " AND po.skbranch = ".mysqli_real_escape_string($cn, $skbranch) : " AND po.skproject = ".mysqli_real_escape_string($cn, $skproject)).
                        " AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."';        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_ContinuePoll');
        foreach ($ar as $mail) {
                // 62378
                $finishdate = "";
                if ($mail[ "skbranch" ] == 0 ) {
                        $finishdate = db_getPollFinishDateBySkroject($cn, $mail[ "skpolltype"], $mail[ "skproject" ]);
                } else {
                        $finishdate = db_getPollFinishDateBySkBranch($cn, $mail[ "skpolltype"], $mail[ "skbranch" ]);
                }
                $userlang = $mail['lang_short'];
                $subject = $mail['polltype_name'].': '.($skproject === NULL ? db_getBranchName($cn, $skbranch, $mail["user_idlanguagecontent"]) : db_getProjectName($cn, $skproject, $mail["user_idlanguagecontent"])).'';
                $url = getCurPageURLWO(array("secureservice", "service")).'poll.php?&idpolltype='.$idpolltype."&".($mail["skproject"] != 0 ? 'skproject='.$mail["skproject"] : 'skbranch='.$mail["skbranch"]);
                createMailContinuePoll($mail['user_email'], getResourceByLang('email.continuepoll.subject', $userlang), $subject, $url, $userlang, $mail['user_name'], $finishdate);
        }
        return $ar;       
}


function db_createMailQueue_StopPoll($cn, $idpolltype, $skbranch, $skproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  lng.lang_short, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name, IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent
                FROM users u
                        INNER JOIN useranswers ua ON u.iduser = ua.iduser
                        INNER JOIN polltypes pt ON pt.skpolltype = ua.skpolltype
                        INNER JOIN pollingobjects po ON po.skpollingobject = ua.skpollingobject
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent)
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        WHERE  u.user_isactive = 1 ".
                        ($skproject === NULL ? " AND po.skbranch = ".mysqli_real_escape_string($cn, $skbranch) : " AND po.skproject = ".mysqli_real_escape_string($cn, $skproject)).
                        " AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."';        ";
                $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_StopPoll');
        foreach ($ar as $mail) {
                $userlang = $mail['lang_short'];
                $subject = $mail['polltype_name'].': '.($skproject === NULL ? db_getBranchName($cn, $skbranch, $mail["user_idlanguagecontent"]) : db_getProjectName($cn, $skproject, $mail["user_idlanguagecontent"])).'';
                createMailStopPoll($mail['user_email'], getResourceByLang('email.stoppoll.subject', $userlang), $subject, '', $userlang, $mail['user_name']);
        }
        return $ar;       
}


function db_createMailQueue_NewPollAnalyst($cn, $idpolltype, $idbranch, $idproject, $uhash){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent, lng.lang_short, CASE WHEN IFNULL(po.skproject,0) > 0 THEN 0 ELSE po.skbranch END as skbranch, po.skproject, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name 
                FROM users u CROSS JOIN useranswers ua 
                        INNER JOIN polltypes pt USING (skpolltype) 
                        INNER JOIN pollingobjects po USING (skpollingobject) 
                        INNER JOIN rightspollingobjects rpo ON u.iduser = rpo.iduser AND po.skpollingobject = rpo.skpollingobject AND rpo.deny_allow = 1
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent)
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                WHERE  u.user_isactive = 1 AND  u.user_hash = '".mysqli_real_escape_string($cn, $uhash)."' AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."'
                AND ".(isset($idproject) ? " po.skproject in (SELECT skproject FROM projects WHERE idproject = '".mysqli_real_escape_string($cn, $idproject)."') " : " po.skbranch in (SELECT skbranch FROM branches WHERE idbranch = '".mysqli_real_escape_string($cn, $idbranch)."') " ).";        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_NewPollAnalyst');
        foreach ($ar as $mail) {
                $url = getCurPageURLWO(array("secureservice", "service")).'adminpoll.php?&idpolltype='.$idpolltype."&".($mail["skbranch"] == 0 ? 'skproject='.$mail["skproject"] : 'skbranch='.$mail["skbranch"]);
                $userlang = $mail['lang_short'];
                createMailNewPollAnalyst($mail['user_email'], getResourceByLang('email.newpollanalyst.subject', $userlang), buildFullPollName($cn, $mail), $url, $userlang, $mail['user_name']);
        }
        return $ar;       
}

function db_createMailQueue_pollContainsErrorsAnalyst($cn, $idpolltype, $idbranch, $idproject, $uhash){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent, lng.lang_short, CASE WHEN IFNULL(po.skproject,0) > 0 THEN 0 ELSE po.skbranch END as skbranch, po.skproject, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name 
                FROM users u CROSS JOIN useranswers ua 
                        INNER JOIN polltypes pt USING (skpolltype) 
                        INNER JOIN pollingobjects po USING (skpollingobject) 
                        INNER JOIN rightspollingobjects rpo ON u.iduser = rpo.iduser AND po.skpollingobject = rpo.skpollingobject AND rpo.deny_allow = 1
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent)
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                WHERE  u.user_isactive = 1 AND  u.user_hash = '".mysqli_real_escape_string($cn, $uhash)."' AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."'        
                AND ".(isset($idproject) ? " po.skproject in (SELECT skproject FROM projects WHERE idproject = '".mysqli_real_escape_string($cn, $idproject)."') " : " po.skbranch in (SELECT skbranch FROM branches WHERE idbranch = '".mysqli_real_escape_string($cn, $idbranch)."') " ).";        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_pollContainsErrorsAnalyst');
        foreach ($ar as $mail) {
                $url = getCurPageURLWO(array("secureservice", "service")).'adminpoll.php?&idpolltype='.$idpolltype."&".($mail["skbranch"] == 0 ? 'skproject='.$mail["skproject"] : 'skbranch='.$mail["skbranch"]);
                $userlang = $mail['lang_short'];
                createMailPollContainsErrorsAnalyst($mail['user_email'], getResourceByLang('email.pollcontainserrorsanalyst.subject', $userlang), buildFullPollName($cn, $mail), $url, $userlang, $mail['user_name']);
        }
        return $ar;       
}

function db_createMailQueue_pollContainsErrorsAnalystAdmin($cn, $idpolltype, $idbranch, $idproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT  IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent, lng.lang_short, CASE WHEN IFNULL(po.skproject,0) > 0 THEN 0 ELSE po.skbranch END as skbranch, po.skproject, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name 
                FROM users u CROSS JOIN useranswers ua
                        INNER JOIN polltypes pt USING (skpolltype) 
                        INNER JOIN pollingobjects po USING (skpollingobject) 
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                WHERE  u.user_isactive = 1 AND user_isadmin = 1 AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."'
                AND ".(isset($idproject) ? " po.skproject in (SELECT skproject FROM projects WHERE idproject = '".mysqli_real_escape_string($cn, $idproject)."') " : " po.skbranch in (SELECT skbranch FROM branches WHERE idbranch = '".mysqli_real_escape_string($cn, $idbranch)."') " ).";        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_pollContainsErrorsAnalystAdmin');
        foreach ($ar as $mail) {
                $url = getCurPageURLWO(array("secureservice", "service")).'adminpoll.php?&idpolltype='.$idpolltype."&".($mail["skbranch"] == 0 ? 'skproject='.$mail["skproject"] : 'skbranch='.$mail["skbranch"]);
                $userlang = $mail['lang_short'];
                createMailPollContainsErrorsAnalystAdmin($mail['user_email'], getResourceByLang('email.pollcontainserrorsanalystadmin.subject', $userlang), buildFullPollName($cn, $mail), $url, $userlang, $mail['user_name']);
        }
        return $ar;       
}

function db_createMailQueue_NewPollAdmin($cn, $idpolltype, $idbranch, $idproject){
        if (!isset($idpolltype) || strlen($idpolltype) == 0 )
                return NULL;

        $deflng = db_getDefaultLangID($cn);
        $deflngInterface = db_getLanguageID($cn, getSetting('portal','defaultLanguage','en'), -1);
        $query = "
                SELECT DISTINCT IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) as user_idlanguagecontent, lng.lang_short, CASE WHEN IFNULL(po.skproject,0) > 0 THEN 0 ELSE po.skbranch END as skbranch, po.skproject, u.iduser, u.user_email, resuser.rft_columnname_text as user_name, respoll.rft_columnname_text as polltype_name 
                FROM users u CROSS JOIN useranswers ua
                        INNER JOIN polltypes pt USING (skpolltype) 
                        INNER JOIN pollingobjects po USING (skpollingobject) 
                        INNER JOIN languages lng ON lng.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflngInterface.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables respoll ON respoll.idtable = 8 AND respoll.idrecord = pt.skpolltype AND respoll.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                        LEFT JOIN resourcefromtables resuser ON resuser.idtable = 6 AND resuser.idrecord = u.iduser AND resuser.idlanguage = IF(IFNULL(u.user_idlanguagecontent,0) = 0, ".$deflng.", u.user_idlanguagecontent) 
                WHERE  u.user_isactive = 1 AND user_isadmin = 1 AND pt.idpolltype = '".mysqli_real_escape_string($cn, $idpolltype)."'
                AND ".(isset($idproject) ? " po.skproject in (SELECT skproject FROM projects WHERE idproject = '".mysqli_real_escape_string($cn, $idproject)."') " : " po.skbranch in (SELECT skbranch FROM branches WHERE idbranch = '".mysqli_real_escape_string($cn, $idbranch)."') " ).";        ";
        $ar = db_runQueryAndReturnArray($cn, $query, 'db_createMailQueue_NewPollAdmin');
        foreach ($ar as $mail) {
                $url = getCurPageURLWO(array("secureservice", "service")).'adminpoll.php?&idpolltype='.$idpolltype."&".($mail["skbranch"] == 0 ? 'skproject='.$mail["skproject"] : 'skbranch='.$mail["skbranch"]);
                $userlang = $mail['lang_short'];
                createMailNewPollAdmin($mail['user_email'], getResourceByLang('email.newpolladmin.subject', $userlang), buildFullPollName($cn, $mail), $url, $userlang, $mail['user_name']);
        }
        return $ar;       
}

function buildFullPollName($cn, $mail){
        return $mail['polltype_name'].': '.(($mail['skbranch'] == 0) ? db_getProjectName($cn, $mail['skproject'], $mail["user_idlanguagecontent"] ) : db_getBranchName($cn, $mail['skbranch'], $mail["user_idlanguagecontent"]));
}

?>