<?php
if(!(is_readable(realpath(dirname(__FILE__).'/../').'/classes/ini_ex.php'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__).'/../').'/classes/ini_ex.php');
} else {
	include_once(realpath(dirname(__FILE__).'/../').'/classes/ini_ex.php');
}

if(!(is_readable(realpath(dirname(__FILE__))."/mail.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__))."/mail.inc");
} else {
	include_once(realpath(dirname(__FILE__))."/mail.inc");
}

function getSettingsFilePath(){
	return realpath(dirname(__FILE__).'/../').'/bsportal.ini';//STU temp
	$inifile = '';
	if( is_readable(realpath(dirname(__FILE__).'/../').'/settings.ini')) {
		$settings = new TIniFileEx(realpath(dirname(__FILE__).'/../').'/settings.ini');
		$inifile = $settings->read('settings', 'inifile', (realpath(dirname(__FILE__).'/../').'/bsportal.ini'), 0);
		return $inifile;
	} else {
		die ('Can\'t load portal main settings (settings.ini) !');
		return null;
	}
}

function getSetting($section, $name, $default, $decode = 0 ){
    $inifile = getSettingsFilePath();
	if( is_readable($inifile)) {
		$settings = new TIniFileEx($inifile);
		return $settings->read($section, $name, $default, $decode);
	} else {
		die ('Can\'t load portal settings (bsportal.ini) !');
		return null;
	}

}

function stopPortal(){
    $inifile = getSettingsFilePath();
	$ini = new TIniFileEx($inifile);
	$ini->write('portal','start',0);
	$ini->updateFile();
}

function StopPortalOnError(){
	$cn = db_connect();
    $inifile = getSettingsFilePath();
	$ini = new TIniFileEx($inifile);
	$ini->write('portal','start',-1);
	$ini->updateFile();
	if ($ini->read('portal','admin.notification_portalstoponerror','') == 1){
		$emarr = db_getUniqueAdminEMails($cn);
		$size = sizeof($emarr);
		if ($size > 0) {
			$portal_url = GetSetting('portal','url',getCurPageURLWO());
			for($i=0; $i<$size; $i++){
				$userlang = $emarr[$i]['lang_short'];
				$lngid = $emarr[$i]['user_idlanguagecontent'];
				$url = $portal_url."/personal.php?lang=".$userlang;
				if (!sendPortalStopOnErrorMessage($emarr[$i]['user_email'], getResourceByLang('email.portalstoponerror.subject', $userlang), $url, $userlang)){
					$usrname = $emarr[$i]['user_name'];
					logmessage( getResourceByLang('log.message.errorsend', $userlang).' '.$usrname);
				}
			}
		}
	}
	clearResource();
	db_disconnect($cn);
	unset($cn);
}

function startPortal(){
	$cn = db_connect();
	db_shrinkIndexes($cn);
	db_setPortalSessionKey($cn, createGuid());
	clearResource();
	checkLanguagesSettings($cn);
	loadResource();
    $inifile = getSettingsFilePath();
	$ini = new TIniFileEx($inifile);
	$ini->write('portal','start',1);
	$ini->updateFile();
	if ($ini->read('portal','admin.notification_portalstart','') == 1){
		$emarr = db_getUniqueAdminEMails($cn);
		$size = sizeof($emarr);
		if ($size > 0) {
			$portal_url = GetSetting('portal','url',getCurPageURLWO());
			for($i=0; $i<$size; $i++){
				$userlang = $emarr[$i]['lang_short'];
				$lngid = $emarr[$i]['user_idlanguagecontent'];
				$url = $portal_url."/personal.php?lang=".$userlang;
				if (!sendPortalStartMessage($emarr[$i]['user_email'], getResourceByLang('email.posrtalstarted.subject', $userlang), $url, $userlang)){
					$usrname = $emarr[$i]['user_name'];
					logmessage( getResourceByLang('log.message.errorsend', $userlang).' '.$usrname);
				}
			}
		}
	}
	db_disconnect($cn);
	unset($cn);
}

?>
